/*********************************************************************
 * FileName:        buttons.c
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         sprut
 * Copyright:       2007 Joerg Bredendiek (sprut)
 *
 *
 ********************************************************************/


/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include "GenericTypeDefs.h"
#include "HardwareProfile.h"             // I/O pin mapping
#include "delays.h"
#include "buttons.h"



/** V A R I A B L E S ********************************************************/
#pragma udata
BYTE		RC_Buttons0;
BYTE		RC_Buttons1;
BYTE		RC_Buttons2;

/** D E C L A R A T I O N S **************************************************/
#pragma code

void	Button_Init(void)
{
	// RC0,1,2  sind die Zeilen > output, aber nur einzeln wrend der Abfrage
	// RB0..7 sind die Spalten  > input  und pull up
    TRISC = 0xFF;
    TRISB = 0xFF;
	LATB  = 0;
	INTCON2bits.RBPU = 0;	// pull up

	mZeile_0 = 0;
	mZeile_1 = 0;
	mZeile_2 = 0;
	RC_Buttons0 = 0;
	RC_Buttons1 = 0;
	RC_Buttons2 = 0;
}	//Button_Init


void	UP_Button(void)
{
	TRISCbits.TRISC0 = 0;
	Delay1TCY();
	RC_Buttons0 = PORTB ^ 0xFF;
	TRISCbits.TRISC0 = 1;

	TRISCbits.TRISC1 = 0;
	Delay1TCY();
	RC_Buttons1 = PORTB ^ 0xFF;
	TRISCbits.TRISC1 = 1;

	TRISCbits.TRISC2 = 0;
	Delay1TCY();
	RC_Buttons2 = PORTB ^ 0xFF;
	TRISCbits.TRISC2 = 1;
}	//UP_Button





